VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CProjekte"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Public m_projekte As New Collection     ' Additional projects
Public m_folderProjekte As Object ' Projekt folder
Dim gSession As MAPI.session


' Return a list of all projects, the text names and all elements from the project folder
Public Function GetProjects() As Collection
   Dim c As New Collection
   Dim s As String
   Dim i As Integer
   Dim obj As Object
   For i = 1 To m_projekte.Count
       s = m_projekte.Item(i)
       c.Add s
   Next i
   If Not (m_folderProjekte Is Nothing) Then
      For Each obj In m_folderProjekte.Items
          c.Add obj.Subject
      Next
   End If
   Set GetProjects = c
End Function

' Open the configuration message or create a new one.
' we create a message in the hidden message of our inbox, the body contains all projects
Public Function ConfigMsg() As MAPI.Message
   Dim msg As Object
   Dim inbox As MAPI.folder
   Dim msgs As MAPI.Messages
   Dim session As New MAPI.session
   On Error GoTo handler
   On Error Resume Next
   Set session.MAPIOBJECT = Application.GetNamespace("MAPI").MAPIOBJECT
   If session.MAPIOBJECT Is Nothing Then
      If gSession Is Nothing Then
         gSession = New MAPI.session
         gSession.Logon
         Set session = gSession
       End If
   End If
   
   Set inbox = session.GetDefaultFolder(CdoDefaultFolderInbox)
   If inbox Is Nothing Then
      MsgBox "Posteinagang nicht gefunden"
      Exit Function
   End If
   On Error Resume Next
   Set msgs = inbox.HiddenMessages
   For Each msg In msgs
       If msg.Subject = "Projects" Then
          Set ConfigMsg = msg
          Exit For
       End If
   Next msg
   If ConfigMsg Is Nothing Then
      Set msg = msgs.Add("Projects")
      msg.fields(CdoPR_MESSAGE_CLASS).Value = "IPM.Project"
      Set ConfigMsg = msg
   End If
   Exit Function
handler:
   MsgBox "Fehler beim Speichern " & Err.Description & " " & Hex$(Err.Number)
End Function

Public Sub Save()
   Dim fields As MAPI.fields
   Dim field As MAPI.field
   Dim config As MAPI.Message
   Dim s As String
   Dim i As Integer
   Dim line As String
   For i = 1 To m_projekte.Count
       line = m_projekte.Item(i)
       s = s + line + vbCr
   Next i
   On Error GoTo handler
   Set config = ConfigMsg
   If config Is Nothing Then
      MsgBox "Konfigurationsmessage kann nicht erstellt werden"
      Exit Sub
   End If
   If Not m_folderProjekte Is Nothing Then
      Set fields = config.fields
      Set field = Nothing
      On Error Resume Next
      Set field = fields.Item("projectfolder")
      On Error GoTo 0
      If field Is Nothing Then Set field = fields.Add("projectfolder", CdoString)
      field.Value = m_folderProjekte.EntryID
   End If
   config.text = s
   config.Update
   Exit Sub
handler:
   MsgBox "Fehler beim Speichern " & Err.Description & " " & Hex$(Err.Number)
   
End Sub

Public Sub Load()
   Dim config As MAPI.Message
   Dim text As String
   Dim s As String
   Set config = ConfigMsg
   If Not (config Is Nothing) Then
        text = config.text
        Do
          p = InStr(1, text, vbCr)
          If p = 0 Then
             m_projekte.Add text
             Exit Do
          Else
             s = Left(text, p - 1)
             text = Mid(text, p + 1)
          End If
          m_projekte.Add s
         Loop
      On Error Resume Next
      Set field = Nothing
      Set fields = config.fields
      Set field = fields.Item("projectfolder")
      On Error GoTo 0
      If Not (field Is Nothing) Then
        On Error Resume Next
        id = field.Value
        Set m_folderProjekte = Application.GetNamespace("MAPI").GetFolderFromID(id)
        On Error GoTo 0
      End If
   End If
         
    
End Sub

Public Sub Init()
   If m_projekte.Count = 0 Then Load
End Sub
Private Sub Class_Initialize()
   Set m_folderProjekte = Nothing
   Load
End Sub
